#!/bin/sh

if ! utils/check_build_env; then
    cd utils
    . ./build_env_init
    cd -
fi

set -e

BUSYBOX_NAME=busybox-1.7.3
BUSYBOX_WK=${ACCPROJ}/busybox
BUSYBOX_ARCHIVE=${ACCSRC}/user/thirdpty/${BUSYBOX_NAME}.tar.bz2
BUSYBOX_CONFIG=${ACCPROJ}/busybox_config
BUSYBOX_SRC=${BUSYBOX_WK}/${BUSYBOX_NAME}
BUSYBOX_BLD=${BUSYBOX_WK}/${BUSYBOX_NAME}_build

# unpack
if [ ! -e "${BUSYBOX_SRC}/Makefile" ]; then
    mkdir -p ${BUSYBOX_WK}
    cd ${BUSYBOX_WK}
    tar xf ${BUSYBOX_ARCHIVE}
    BUSYBOX_SRC=${BUSYBOX_WK}/${BUSYBOX_NAME}
fi

# setup build dir
mkdir -p ${BUSYBOX_BLD}
cp -f ${BUSYBOX_CONFIG} ${BUSYBOX_BLD}/.config

cd ${BUSYBOX_SRC}
make O=${BUSYBOX_BLD} oldconfig

cd ${BUSYBOX_BLD}
make

cp ${BUSYBOX_BLD}/busybox ${ACCROOTFS}/bin/
